/*
 * Java
 *
 * Copyright 2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.event.controller;

import ej.microui.event.generator.Command;

/**
 * Event handler that manages {@link Command} events.
 * 
 * @since 2.0
 */
public interface CommandEventHandler {

	/**
	 * Handles command event.
	 *
	 * @param command
	 *            the command to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 */
	boolean onCommand(int command);

}
