/*
 * Java
 *
 * Copyright 2010-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.event;

/**
 * MicroUI features int-based events, allowing for a rich event mechanism compatible with scare resources. This class
 * provides {@link EventGenerator} classes with event constants and helper methods to build and analyse events. <br>
 * <p>
 * An event has a type, a 8-bit figure that forms the most significant byte of the int-event, followed by 8-bits which
 * is the generator id quantity, and followed by 16-bit of data.<br>
 * <p>
 * event : type (8-bit) + generatorID (8-bit) + data (16-bit)<br>
 * <p>
 * The very first 16 types [0x00..0x0f], some of which are defined by constants in this class, are MicroUI reserved. An
 * application may create as many as 240 different kind of events.
 * 
 * @see EventGenerator
 */
public class Event {

	/**
	 * The COMMAND event type.<br>
	 */
	public static final int COMMAND = 0x00;

	/**
	 * The BUTTON event type.<br>
	 */
	public static final int BUTTON = 0x01;

	/**
	 * The KEYBOARD event type.<br>
	 */
	public static final int KEYBOARD = 0x02;

	/**
	 * The POINTER event type.<br>
	 */
	public static final int POINTER = 0x03;

	/**
	 * The KEYPAD event type.<br>
	 */
	public static final int KEYPAD = 0x04;

	/**
	 * The STATE event type.<br>
	 */
	public static final int STATE = 0x05;

	/**
	 * Forbidden constructor: cannot instantiate an event object.
	 */
	private Event() {
	}

	/**
	 * Builds an event from a given type, an eventGenerator and data.
	 * 
	 * @param type
	 *            the type of the event to build
	 * @param gen
	 *            the generator associated with the event
	 * @param data
	 *            the data of the event to build
	 * @return the event as an <code>int</code>
	 */
	public static int buildEvent(int type, EventGenerator gen, int data) {
		throw new RuntimeException();
	}

	/**
	 * Returns the type of an event.
	 * 
	 * @param event
	 *            an event
	 * @return event's type as an <code>int</code>
	 */
	public static int getType(int event) {
		throw new RuntimeException();
	}

	/**
	 * Returns the event's data issued by a generator.
	 * 
	 * @param event
	 *            an event
	 * @return event's data as an <code>int</code>
	 */
	public static int getData(int event) {
		throw new RuntimeException();
	}

	/**
	 * Returns the event's generator id.
	 * 
	 * @param event
	 *            an event
	 * @return event's generator as an <code>int</code>
	 */
	public static int getGeneratorID(int event) {
		throw new RuntimeException();
	}

	/**
	 * Gets a converter out of an event assuming the event has been generated by an {@link EventGenerator} that has been
	 * previously added to the system pool.
	 * 
	 * @param event
	 *            an event
	 * @return the associated {@link EventGenerator}
	 * @throws NullPointerException
	 *             if the generator does not exist (most likely because the event is not an EventGenerator related
	 *             event).
	 * @see EventGenerator#addToSystemPool()
	 */
	public static EventGenerator getGenerator(int event) {
		throw new RuntimeException();
	}
}
