/*
 *	Java
 *
 *	Copyright 2015-2016 IS2T. All rights reserved.
 *	IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package ej.microui.display.transform;

import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;

/**
 * This class holds a context in order to perform a flip on images (0, 90, 180 or 270 degrees).<br>
 * <p>
 * An image flip instance holds a global state for all drawings. Several instances can be created at the same time.
 * However a default instance is created on MicroUI framework startup and is always available.<br>
 *
 * @since 2.0
 */
public class ImageFlip extends AbstractTransform {

	/**
	 * Default instance created on MicroUI framework startup.
	 */
	public static final ImageFlip Singleton = new ImageFlip();

	/**
	 * Specify the flip to apply when drawing an image.
	 *
	 * @see ImageFlip#draw(GraphicsContext, Image, int, int, int)
	 */
	public enum Action {

		/**
		 * Reset the flip action (0 degrees).<br>
		 * This is the default action.
		 */
		FLIP_NONE,

		/**
		 * Flip anticlockwise at 90 degrees.
		 */
		FLIP_90,

		/**
		 * Flip at 180 degrees.
		 */
		FLIP_180,

		/**
		 * Flip anticlockwise at 270 degrees.
		 */
		FLIP_270;
	}

	/**
	 * Returns the current {@link Action}.
	 *
	 * @return the current {@link Action}.
	 */
	public Action getAction() {
		throw new RuntimeException();
	}

	/**
	 * Set the new {@link Action}.
	 *
	 * @param action
	 *            the action to set.
	 */
	public void setAction(Action action) {
		throw new RuntimeException();
	}

	/**
	 * Draw the {@link Image} in the {@link GraphicsContext} at given anchor position and using the current
	 * {@link Action}.
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where to render the drawing.
	 * @param image
	 *            the {@link Image} to draw
	 * @param x
	 *            the x coordinate of the image reference anchor point
	 * @param y
	 *            the y coordinate of the image reference anchor point
	 * @param anchor
	 *            position of the image reference point around the anchor point
	 * @throws NullPointerException
	 *             if @{code image} or @{code gc} is @{code null}
	 * @throws IllegalArgumentException
	 *             if <code>anchor</code> is not a valid value (<code>BASELINE</code> is illegal).
	 */
	public void draw(GraphicsContext gc, Image image, int x, int y, int anchor) {
		throw new RuntimeException();
	}

	// /**
	// * Draw the specified part of {@link Image} in the {@link GraphicsContext} at given anchor position and the
	// current
	// * {@link Action}.
	// *
	// * @param gc
	// * the {@link GraphicsContext} where render the drawing.
	// * @param image
	// * the {@link Image} to draw
	// * @param srcX
	// * the top-left X coordinate of the region to draw
	// * @param srcY
	// * the top-left Y coordinate of the region to draw
	// * @param srcWidth
	// * the region width
	// * @param srcHeight
	// * the region height
	// * @param x
	// * the x coordinate of the image reference anchor point
	// * @param y
	// * the y coordinate of the image reference anchor point
	// * @param anchor
	// * position of the image reference point around the anchor point
	// */
	// public void draw(GraphicsContext gc, Image image, int srcX, int srcY, int srcWidth, int srcHeight, int x, int y,
	// int anchor) {
	// throw new RuntimeException();
	// }

}
