/*
 * Java
 *
 * Copyright 2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.hoka.log;

/**
 * Server logger
 */
public interface Logger {

	/**
	 * log with level trace
	 *
	 * @param msg
	 *            log message
	 */
	void trace(String msg);

	/**
	 * log with level debug
	 *
	 * @param msg
	 *            log message
	 */
	void debug(String msg);

	/**
	 * log with level info
	 *
	 * @param msg
	 *            log message
	 */
	void info(String msg);

	/**
	 * log with level warn
	 *
	 * @param msg
	 *            log message
	 */
	void warn(String msg);

	/**
	 * log with level error
	 *
	 * @param msg
	 *            log message
	 */
	void error(String msg);

	/**
	 * log with level error
	 *
	 * @param msg
	 *            log message
	 * @param e
	 *            error
	 */
	void error(String msg, Throwable e);

	/**
	 * log with level error
	 *
	 * @param e
	 *            error
	 */
	void error(Throwable e);

	/**
	 * @return true if trace enabled, false otherwise
	 */
	boolean isTraceEnabled();

	/**
	 * @return true if debug enabled, false otherwise
	 */
	boolean isDebugEnabled();

	/**
	 * @return true if info enabled, false otherwise
	 */
	boolean isInfoEnabled();

	/**
	 * @return true if warn enabled, false otherwise
	 */
	boolean isWarnEnabled();

	/**
	 * @return true if error enabled, false otherwise
	 */
	boolean isErrorEnabled();

}
