/*
 * Java
 *
 * Copyright 2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.hoka.http;

/**
 * Stop a request processing
 */
class HaltException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	private String status = HttpConstants.HTTP_STATUS_OK;
	private String body = ""; //$NON-NLS-1$

	/**
	 *
	 */
	public HaltException() {
		super(null, null);
	}

	/**
	 * @param status
	 *            http status
	 *
	 */
	public HaltException(String status) {
		this();
		this.status = status;

	}

	/**
	 * @param status
	 *            http status
	 * @param body
	 *            error message
	 */
	public HaltException(String status, String body) {
		this();
		this.status = status;
		this.body = body;
	}

	/**
	 * Gets the status.
	 *
	 * @return the status.
	 */
	public String getStatus() {
		return this.status;
	}

	/**
	 * Gets the body.
	 *
	 * @return the body.
	 */
	public String getBody() {
		return this.body;
	}

}
