/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg.image.pathdata;

import ej.microvg.image.ImageGenerator.Format;

/**
 * Encodes a path with 8-bit values: the commands and the commands' attributes are encoded with 8-bit signed values.
 */
public class SingleArrayPathDataS8 extends SingleArrayPathData {

	@Override
	public Format getFormat() {
		return Format.VG_S8;
	}

	@Override
	public void appendCommand(int command) {
		append((byte) command);
	}

	@Override
	public void appendCoordinate(double coordinate) {
		append((byte) coordinate);
	}

	private void append(byte i) {
		write(i);
	}

}
