/*
 * Java
 *
 * 2020 ESR - Not subject to Copyright.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui.display;

/**
 * Available list of {@link Font} built-in identifiers.
 * <p>
 * A font has a set of identifiers. An identifier is an integer which specifies whether the font is able to render
 * specific languages and alphabets. A value has been assigned to each of the 80 built-in identifiers.
 */
public final class FontIdentifiers {

	/**
	 * Constant for arabic font identifier.
	 */
	public static final int ARABIC = 1;

	/**
	 * Constant for armenian font identifier.
	 */
	public static final int ARMENIAN = 2;

	/**
	 * Constant for balinese font identifier.
	 */
	public static final int BALINESE = 3;

	/**
	 * Constant for bengali font identifier.
	 */
	public static final int BENGALI = 4;

	/**
	 * Constant for bopomofo font identifier.
	 */
	public static final int BOPOMOFO = 5;

	/**
	 * Constant for braille font identifier.
	 */
	public static final int BRAILLE = 6;

	/**
	 * Constant for buginese font identifier.
	 */
	public static final int BUGINESE = 7;

	/**
	 * Constant for buhid font identifier.
	 */
	public static final int BUHID = 8;

	/**
	 * Constant for canadian aboriginal font identifier.
	 */
	public static final int CANADIAN_ABORIGINAL = 9;

	/**
	 * Constant for cherokee font identifier.
	 */
	public static final int CHEROKEE = 10;

	/**
	 * Constant for coptic font identifier.
	 */
	public static final int COPTIC = 11;

	/**
	 * Constant for cyrillic font identifier.
	 */
	public static final int CYRILLIC = 14;

	/**
	 * Constant for devanagari font identifier.
	 */
	public static final int DEVANAGARI = 16;

	/**
	 * Constant for ethiopic font identifier.
	 */
	public static final int ETHIOPIC = 17;

	/**
	 * Constant for georgian font identifier.
	 */
	public static final int GEORGIAN = 18;

	/**
	 * Constant for glagolitic font identifier.
	 */
	public static final int GLAGOLITIC = 19;

	/**
	 * Constant for greek font identifier.
	 */
	public static final int GREEK = 21;

	/**
	 * Constant for gujarati font identifier.
	 */
	public static final int GUJARATI = 22;

	/**
	 * Constant for gurmukhi font identifier.
	 */
	public static final int GURMUKHI = 23;

	/**
	 * Constant for han font identifier.
	 */
	public static final int HAN = 24;

	/**
	 * Constant for hangul font identifier.
	 */
	public static final int HANGUL = 25;

	/**
	 * Constant for hanunoo font identifier.
	 */
	public static final int HANUNOO = 26;

	/**
	 * Constant for hebrew font identifier.
	 */
	public static final int HEBREW = 27;

	/**
	 * Constant for hiragana font identifier.
	 */
	public static final int HIRAGANA = 28;

	/**
	 * Constant for kannada font identifier.
	 */
	public static final int KANNADA = 29;

	/**
	 * Constant for katakana font identifier.
	 */
	public static final int KATAKANA = 30;

	/**
	 * Constant for khmer font identifier.
	 */
	public static final int KHMER = 32;

	/**
	 * Constant for lao font identifier.
	 */
	public static final int LAO = 33;

	/**
	 * Constant for latin font identifier.
	 */
	public static final int LATIN = 34;

	/**
	 * Constant for limbu font identifier.
	 */
	public static final int LIMBU = 35;

	/**
	 * Constant for malayalam font identifier.
	 */
	public static final int MALAYALAM = 36;

	/**
	 * Constant for mongolian font identifier.
	 */
	public static final int MONGOLIAN = 37;

	/**
	 * Constant for myanmar font identifier.
	 */
	public static final int MYANMAR = 38;

	/**
	 * Constant for new tai lue font identifier.
	 */
	public static final int NEW_TAI_LUE = 39;

	/**
	 * Constant for nko font identifier.
	 */
	public static final int NKO = 40;

	/**
	 * Constant for ogham font identifier.
	 */
	public static final int OGHAM = 41;

	/**
	 * Constant for oriya font identifier.
	 */
	public static final int ORIYA = 42;

	/**
	 * Constant for phags pa font identifier.
	 */
	public static final int PHAGS_PA = 44;

	/**
	 * Constant for runic font identifier.
	 */
	public static final int RUNIC = 46;

	/**
	 * Constant for sinhala font identifier.
	 */
	public static final int SINHALA = 48;

	/**
	 * Constant for syloti nagri font identifier.
	 */
	public static final int SYLOTI_NAGRI = 49;

	/**
	 * Constant for syriac font identifier.
	 */
	public static final int SYRIAC = 50;

	/**
	 * Constant for tagalog font identifier.
	 */
	public static final int TAGALOG = 51;

	/**
	 * Constant for tagbanwa font identifier.
	 */
	public static final int TAGBANWA = 52;

	/**
	 * Constant for tai le font identifier.
	 */
	public static final int TAI_LE = 53;

	/**
	 * Constant for tamil font identifier.
	 */
	public static final int TAMIL = 54;

	/**
	 * Constant for telugu font identifier.
	 */
	public static final int TELUGU = 55;

	/**
	 * Constant for thaana font identifier.
	 */
	public static final int THAANA = 56;

	/**
	 * Constant for thai font identifier.
	 */
	public static final int THAI = 57;

	/**
	 * Constant for tibetan font identifier.
	 */
	public static final int TIBETAN = 58;

	/**
	 * Constant for tifinagh font identifier.
	 */
	public static final int TIFINAGH = 59;

	/**
	 * Constant for yi font identifier.
	 */
	public static final int YI = 61;

	/**
	 * Constant for common font identifier.
	 */
	public static final int COMMON = 62;

	/**
	 * Constant for inherited font identifier.
	 */
	public static final int INHERITED = 63;

	/**
	 * Constant for sundanese font identifier.
	 */
	public static final int SUNDANESE = 64;

	/**
	 * Constant for lepcha font identifier.
	 */
	public static final int LEPCHA = 65;

	/**
	 * Constant for ol chiki font identifier.
	 */
	public static final int OL_CHIKI = 66;

	/**
	 * Constant for vai font identifier.
	 */
	public static final int VAI = 67;

	/**
	 * Constant for saurashtra font identifier.
	 */
	public static final int SAURASHTRA = 68;

	/**
	 * Constant for kayah li font identifier.
	 */
	public static final int KAYAH_LI = 69;

	/**
	 * Constant for rejang font identifier.
	 */
	public static final int REJANG = 70;

	/**
	 * Constant for cham font identifier.
	 */
	public static final int CHAM = 71;

	/**
	 * Constant for tai tham font identifier.
	 */
	public static final int TAI_THAM = 72;

	/**
	 * Constant for tai viet font identifier.
	 */
	public static final int TAI_VIET = 73;

	/**
	 * Constant for samaritan font identifier.
	 */
	public static final int SAMARITAN = 74;

	/**
	 * Constant for lisu font identifier.
	 */
	public static final int LISU = 75;

	/**
	 * Constant for bamum font identifier.
	 */
	public static final int BAMUM = 76;

	/**
	 * Constant for javanese font identifier.
	 */
	public static final int JAVANESE = 77;

	/**
	 * Constant for meetei mayek font identifier.
	 */
	public static final int MEETEI_MAYEK = 78;

	/**
	 * Constant for batak font identifier.
	 */
	public static final int BATAK = 79;

	/**
	 * Constant for mandaic font identifier.
	 */
	public static final int MANDAIC = 80;

	private FontIdentifiers() {
		// cannot instanciate this class
	}
}
