/*
 * Copyright (c) 2002, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * Copyright 2020 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.google.protobuf;

/**
 *
 */
final class Utf8Util {

	static final int MIN_SUPPLEMENTARY_CODE_POINT = 0x010000;
	static final char MIN_HIGH_SURROGATE = '\uD800';
	static final char MIN_LOW_SURROGATE = '\uDC00';
	static final char MAX_HIGH_SURROGATE = '\uDBFF';
	static final char MAX_LOW_SURROGATE = '\uDFFF';
	static final char MIN_SURROGATE = MIN_HIGH_SURROGATE;
	static final char MAX_SURROGATE = MAX_LOW_SURROGATE;

	static int toCodePoint(char high, char low) {
		return ((high << 10) + low) + (MIN_SUPPLEMENTARY_CODE_POINT - (MIN_HIGH_SURROGATE << 10) - MIN_LOW_SURROGATE);
	}

	static boolean isSurrogatePair(char high, char low) {
		boolean isHigh = high >= MIN_HIGH_SURROGATE && high < (MAX_HIGH_SURROGATE + 1);
		boolean isLow = low >= MIN_LOW_SURROGATE && low < (MAX_LOW_SURROGATE + 1);
		return isHigh && isLow;
	}
}
