/*
 * Java
 *
 * Copyright 2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.nls;

/**
 * Interface for using generated plural information classes.
 */
public interface NLSPlural {

	/**
	 * Processes the given count value through the plural expression for the given locale in order to know which form of
	 * a given plural message to use, if the message is not singular only altogether.
	 *
	 * @param messageID
	 *            the ID of the message.
	 * @param count
	 *            the count value.
	 * @param localeIndex
	 *            the index of the locale to use the plural expression of.
	 * @throws IllegalArgumentException
	 *             if the locale argument doesn't match any of the locale name
	 * @return the index of the form of a plural message to use.
	 */
	public int processCount(int messageID, int count, int localeIndex) throws IllegalArgumentException;

}
