/*
 * Copyright 2010-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.sni;

/**
 * A pool of reusable resources. A buffer is reserved using {@link #reserve()} and released using
 * {@link #release(Object)}. Pool may have a maximum number of resources.
 */
public abstract class PoolOfReusableResources {

	/**
	 * Allocate a new pool of resources
	 *
	 * @param maxNbResources
	 *            a strictly positive integer giving the maximum number of allocated resources, or 0 if an unlimited
	 *            number of resources is allowed
	 */
	public PoolOfReusableResources(int maxNbResources) {
		throw new RuntimeException();
	}

	/**
	 * Reserve a buffer. In case all resources are in use and the maximum number of resources is not reached, a new
	 * buffer is allocated. Otherwise this function blocks until a buffer is available
	 *
	 * @return an array
	 */
	public synchronized Object reserve() {
		throw new RuntimeException();
	}

	public synchronized void release(Object buffer) {
		throw new RuntimeException();
	}

	/**
	 * Allocate a new resource
	 *
	 * @return the new allocated resource
	 */
	protected abstract Object newResource();

}
