/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth;

/**
 * Provides constants related to the commands. This class is duplicated in rcommand-bluetooth-controller.
 */
public class Commands {

	// command names
	public static final String BLUETOOTH_EVENT = "bluetooth_event";
	public static final String BLUETOOTH_ENABLE = "bluetooth_enable";
	public static final String BLUETOOTH_DISABLE = "bluetooth_disable";
	public static final String BLUETOOTH_START_SCANNING = "bluetooth_start_scanning";
	public static final String BLUETOOTH_STOP_SCANNING = "bluetooth_stop_scanning";
	public static final String BLUETOOTH_START_ADVERTISING = "bluetooth_start_advertising";
	public static final String BLUETOOTH_STOP_ADVERTISING = "bluetooth_stop_advertising";
	public static final String BLUETOOTH_CONNECT = "bluetooth_connect";
	public static final String BLUETOOTH_DISCONNECT = "bluetooth_disconnect";
	public static final String BLUETOOTH_PAIR = "bluetooth_pair";
	public static final String BLUETOOTH_PAIR_REPLY = "bluetooth_pair_reply";
	public static final String BLUETOOTH_PASSKEY_REPLY = "bluetooth_passkey_reply";
	public static final String BLUETOOTH_DISCOVER_SERVICES = "bluetooth_discover_services";
	public static final String BLUETOOTH_ADD_SERVICE = "bluetooth_add_service";
	public static final String BLUETOOTH_SEND_READ_REQUEST = "bluetooth_send_read_request";
	public static final String BLUETOOTH_SEND_WRITE_REQUEST = "bluetooth_send_write_request";
	public static final String BLUETOOTH_SEND_READ_RESPONSE = "bluetooth_send_read_response";
	public static final String BLUETOOTH_SEND_WRITE_RESPONSE = "bluetooth_send_write_response";
	public static final String BLUETOOTH_SEND_NOTIFICATION = "bluetooth_send_notification";

	// status codes returned by most commands
	public static final int OK = 0;
	public static final int ERROR = 1;

	private Commands() {
		// private constructor
	}
}
