/*******************************************************************************
 * Copyright (c) 2009, 2014 IBM Corp.
 * Copyright 2019-2021 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *    http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Dave Locke - initial API and implementation and/or initial documentation
 *    MicroEJ Corp. - MicroPaho implementation and optimizations on MicroEJ
 */
package org.eclipse.paho.client.mqttv3;

/**
 * Enables an application to be notified when asynchronous events related to the client occur. Classes implementing this
 * interface can be registered using {@link IMqttClient#setCallback(MqttCallback)}.
 */
public interface MqttCallback {

	/**
	 * This method is called when the connection to the server is lost.
	 *
	 * @param cause
	 *            the reason behind the loss of connection.
	 */
	public void connectionLost(Throwable cause);

	/**
	 * This method is called when a message arrives from the server.
	 *
	 * <p>
	 * This method is invoked synchronously by the MQTT client.
	 * </p>
	 * <p>
	 * If an implementation of this method throws an <code>Exception</code>, then the client will be shut down.
	 * </p>
	 * <p>
	 * Any additional messages which arrive while an implementation of this method is running will back up on the
	 * network.
	 * </p>
	 *
	 * @param topic
	 *            name of the topic on the message was published to.
	 * @param message
	 *            the actual message.
	 * @throws Exception
	 *             if a terminal error has occurred, and the client should be shut down.
	 */
	public void messageArrived(String topic, MqttMessage message) throws Exception;

}
