/*
 * Copyright (c) 1997, 2013, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2017-2022 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. The Copyright holder(s) designates
 * this particular file as subject to the "Classpath" exception as provided
 * by the Copyright holder(s) in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact the Copyright holder(s) if you need additional information
 * or have any questions.
 * (if Oracle: 500 Oracle Parkway, Redwood Shores, CA 94065 USA or visit www.oracle.com)
 */

package java.security.spec;

/**
 * A (transparent) specification of the key material that constitutes a cryptographic key.
 *
 * <p>
 * If the key is stored on a hardware device, its specification may contain information that helps identify the key on
 * the device.
 *
 * <P>
 * A key may be specified in an algorithm-specific way, or in an algorithm-independent encoding format (such as ASN.1).
 * For example, a DSA private key may be specified by its components {@code x}, {@code p}, {@code q}, and {@code g}, or
 * it may be specified using its DER encoding.
 *
 * <P>
 * This interface contains no methods or constants. Its only purpose is to group (and provide type safety for) all key
 * specifications. All key specifications must implement this interface.
 *
 * @author Jan Luehe
 *
 *
 * @see java.security.Key
 *
 * @since 1.2
 */

public interface KeySpec {
}
