/*
 * Copyright (c) 1997, 2019, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2023 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package java.security.cert;

/**
 * Certificate Expired Exception. This is thrown whenever the current {@code Date} or the specified {@code Date} is
 * after the {@code notAfter} date/time specified in the validity period of the certificate.
 *
 * @author Hemma Prafullchandra
 * @since 1.2
 */
public class CertificateExpiredException extends CertificateException {

	private static final long serialVersionUID = 9071001339691533771L;

	/**
	 * Constructs a CertificateExpiredException with no detail message. A detail message is a String that describes this
	 * particular exception.
	 */
	public CertificateExpiredException() {
		super();
	}

	/**
	 * Constructs a CertificateExpiredException with the specified detail message. A detail message is a String that
	 * describes this particular exception.
	 *
	 * @param message
	 *            the detail message.
	 */
	public CertificateExpiredException(String message) {
		super(message);
	}
}
