/*
 * Java
 *
 * Copyright 2019-2024 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.bluetooth.BluetoothConnection;
import ej.library.iot.rcommand.bluetooth.BluetoothController;
import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;

public class SendPairRequestEndpoint implements Endpoint {

	private final BluetoothController controller;

	private short connHandle;

	public SendPairRequestEndpoint(BluetoothController controller) {
		this.controller = controller;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_SEND_PAIR_REQUEST;
	}

	@Override
	public void readRequestBody(CommandReader reader) throws IOException {
		this.connHandle = (short) reader.readInt();
	}

	@Override
	public void writeResponseBody(CommandSender sender) throws IOException {
		BluetoothConnection connection = this.controller.getConnection(this.connHandle);
		if (connection != null && connection.sendPairRequest()) {
			sender.sendInt(Commands.OK);
		} else {
			sender.sendInt(Commands.ERROR);
		}
	}
}
