/*
 * Java
 *
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.BluetoothController;
import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;

public class PollEventEndpoint implements Endpoint {

	private final BluetoothController controller;

	public PollEventEndpoint(BluetoothController controller) {
		this.controller = controller;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_POLL_EVENT;
	}

	@Override
	public void readRequestBody(CommandReader reader) throws IOException {
		// do nothing
	}

	@Override
	public void writeResponseBody(CommandSender sender) throws IOException {
		byte[] event = this.controller.pollEvent();
		sender.sendByteArray(event == null ? new byte[0] : event);
	}
}
