package java.lang;

/**
 * Every Java application has a single instance of class <code>Runtime</code> that allows the
 * application to interface with the environment in which the application is running. The current
 * runtime can be obtained from the <code>getRuntime</code> method.
 * <p>
 * An application cannot create its own instance of this class.
 *
 * @see java.lang.Runtime#getRuntime()
 */
public class Runtime {

	private Runtime() { 
		// This class cannot be instantiated.  
		throw new RuntimeException(); 
	}

	/**
	 * Returns the runtime object associated with the current Java application. Most of the methods of
	 * class <code>Runtime</code> are instance methods and must be invoked with respect to the current
	 * runtime object.
	 *
	 * @return the <code>Runtime</code> object associated with the current Java application.
	 */
	public static Runtime getRuntime() {
		throw new RuntimeException();
	}

	/**
	 * Terminates the currently running Java virtual machine by initiating its shutdown sequence. This
	 * method never returns normally. The argument serves as a status code; by convention, a nonzero
	 * status code indicates abnormal termination.
	 *
	 * <p>
	 * The <code>{@link System#exit(int) System.exit}</code> method is the conventional and convenient means
	 * of invoking this method.
	 * <p>
	 *
	 * @param status
	 *        Termination status. By convention, a nonzero status code indicates abnormal termination.
	 */
	public void exit(int status) {
		throw new RuntimeException();
	}

	/**
	 * Returns the amount of free memory in the Java Virtual Machine. Calling the <code>gc</code> method
	 * may result in increasing the value returned by <code>freeMemory.</code>
	 *
	 * @return an approximation to the total amount of memory currently available for future allocated
	 *         objects, measured in bytes.
	 */
	public long freeMemory() {
		throw new RuntimeException();
	}

	/**
	 * Runs the garbage collector. Calling this method suggests that the Java virtual machine expend
	 * effort toward recycling unused objects in order to make the memory they currently occupy
	 * available for quick reuse. When control returns from the method call, the virtual machine has
	 * made its best effort to recycle all discarded objects.
	 * <p>
	 * The name <code>gc</code> stands for "garbage collector". The virtual machine performs this
	 * recycling process automatically as needed even if the <code>gc</code> method is not invoked
	 * explicitly.
	 * <p>
	 * The method {@link System#gc()} is the conventional and convenient means of invoking this method.
	 */
	public void gc() {
		throw new RuntimeException();
	}

	/**
	 * Returns the maximum amount of memory that the Java virtual machine will attempt to use. If there
	 * is no inherent limit then the value {@link java.lang.Long#MAX_VALUE} will be returned.
	 *
	 * @return the maximum amount of memory that the virtual machine will attempt to use, measured in
	 *         bytes
	 */
	public long maxMemory() {
		throw new RuntimeException();
	}

	/**
	 * Returns the total amount of memory in the Java virtual machine. The value returned by this method
	 * may vary over time, depending on the host environment.
	 * <p>
	 * Note that the amount of memory required to hold an object of any given type may be
	 * implementation-dependent.
	 *
	 * @return the total amount of memory currently available for current and future objects, measured
	 *         in bytes.
	 */
	public long totalMemory() {
		throw new RuntimeException();
	}
}