/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth.listeners.impl;

import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.listeners.RemoteServiceListener;

/**
 * The <code>DefaultRemoteServiceListener</code> class provides a default implementation of the
 * {@link ej.bluetooth.listeners.RemoteServiceListener} interface.
 * <p>
 * The implementation of each method does nothing.
 */
public class DefaultRemoteServiceListener implements RemoteServiceListener {

	@Override
	public void onReadCompleted(BluetoothConnection connection, BluetoothAttribute attribute, byte status,
			byte[] value) {
		throw new RuntimeException();
	}

	@Override
	public void onWriteCompleted(BluetoothConnection connection, BluetoothAttribute attribute, byte status) {
		throw new RuntimeException();
	}

	@Override
	public void onNotificationReceived(BluetoothConnection connection, BluetoothCharacteristic characteristic,
			byte[] value) {
		throw new RuntimeException();
	}
}
