/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

import ej.annotation.Nullable;

/**
 * The <code>BluetoothAttribute</code> class represents a remote or a local GATT attribute. An attribute is either a
 * characteristic or a descriptor.
 * <p>
 * This class provides methods to get the UUID of the attribute and to get the service to which the attribute belongs.
 */
public abstract class BluetoothAttribute {

	/**
	 * Private constructor.
	 */
	/* package */ BluetoothAttribute() {
		throw new RuntimeException();
	}

	/**
	 * Returns the UUID of this attribute.
	 *
	 * @return the UUID of this attribute.
	 */
	public BluetoothUuid getUuid() {
		throw new RuntimeException();
	}

	/**
	 * Returns the service to which this attribute belongs.
	 * <p>
	 * This method returns {@code null} if this is a local attribute and it has not been added to a service.
	 *
	 * @return the service to which this attribute belongs.
	 */
	public @Nullable BluetoothService getService() {
		throw new RuntimeException();
	}
}
