/*
 * Copyright 2017-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bon;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;

/**
 * A resource buffer contains a set of data which is compacted to obtain a
 * minimal footprint.
 * <p>
 * A data is a 8-bits word (signed or unsigned), a 16-bits word (signed or
 * unsigned), a 32-bits (signed or unsigned), a float, a double, a
 * {@link String} or a {@link ResourceArray}.
 */
public class ResourceBuffer implements Closeable {

	/**
	 * Opens a {@link ResourceBuffer} on the resource described by its path.
	 *
	 * @param name
	 *            absolute resource name, as defined by
	 *            {@link Class#getResourceAsStream(String)} (name must begin with
	 *            character '/').
	 * @throws IllegalArgumentException
	 *             when path does not denote an absolute path.
	 * @throws IOException
	 *             when the resource is not available in application classpath.
	 * @throws NullPointerException
	 *             if resource is null
	 *
	 */
	public ResourceBuffer(String name) throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Closes this resource and releases any system resources associated with the
	 * resource. All next <code>read</code> calls will cause an unknown behavior.
	 *
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	@Override
	public void close() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Reads a 32-bits signed integer and increments position in the data.
	 *
	 * @return the value read.
	 * @throws EOFException
	 *             when end of file is reached.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public int readVarSInt() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Reads a 32-bits unsigned integer and increments position in the data.
	 *
	 * @return the value read.
	 * @throws EOFException
	 *             when end of file is reached.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public int readVarUInt() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Reads a 64-bits signed integer and increments position in the data.
	 *
	 * @return the value read.
	 * @throws EOFException
	 *             when end of file is reached.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public long readVarLong() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Reads a boolean and increments position in the data.
	 *
	 * @return the value read.
	 * @throws EOFException
	 *             when end of file is reached.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public boolean readBoolean() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Reads a byte and increments position in the data.
	 *
	 * @return the value read.
	 * @throws EOFException
	 *             when end of file is reached.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public byte readByte() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Reads a short and increments position in the data.
	 *
	 * @return the value read.
	 * @throws EOFException
	 *             when end of file is reached.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public short readShort() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Reads a char and increments position in the data.
	 *
	 * @return the value read.
	 * @throws EOFException
	 *             when end of file is reached.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public char readChar() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Reads an integer and increments position in the data.
	 *
	 * @return the value read.
	 * @throws EOFException
	 *             when end of file is reached.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public int readInt() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Reads a {@link String} and increments position in the data.
	 *
	 * @return the {@link String} read.
	 * @throws EOFException
	 *             when end of file is reached.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public String readString() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Reads a {@link ResourceArray} and increments position in the data.
	 *
	 * @return the {@link ResourceArray} read.
	 * @throws EOFException
	 *             when end of file is reached.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public ResourceArray readArray() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Sets the buffer position indicator. The new position, measured in bytes, is
	 * obtained by adding offset bytes to the start of the buffer.
	 *
	 * @param offset
	 *            the offset from start of buffer.
	 * @throws IndexOutOfBoundsException
	 *             if there is no position with the given offset.
	 * @throws EOFException
	 *             when end of file is reached.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public void seek(long offset) throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Returns the available number of bytes that can be read (or skipped over) from
	 * this buffer.
	 *
	 * @return the number of bytes that can be read
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public int available() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Force to align position on given number of bytes. A value lower than 2 is
	 * ignored.
	 *
	 * @param nbBytes
	 *            number of bytes to align
	 * @throws EOFException
	 *             when end of file is reached.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public void align(int nbBytes) throws IOException {
		throw new RuntimeException();
	}
}
