/*
 * Copyright 2015-2019 IS2T. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break IS2T warranties on the whole library.
 */
package ej.service.registry;

import ej.service.ServicePermission;
import ej.service.ServiceRegistry;
import ej.service.loader.SimpleServiceLoader;

/**
 * Service loader that creates service instance based on default service implementation class.
 */
public class SimpleServiceRegistry extends SimpleServiceLoader implements ServiceRegistry {

	@Override
	public <T> void register(Class<T> service, T implementation) {
		checkServicePermission(service, ServicePermission.REGISTER_ACTION);

		putService(service, implementation);
	}

	@Override
	public <T> void unregister(Class<T> service, T implementation) {
		checkServicePermission(service, ServicePermission.UNREGISTER_ACTION);

		synchronized (this.services) {
			Object candidate = this.services.get(service);
			if (candidate == implementation) {
				this.services.remove(service);
			}
		}
	}

}
