/*
 * Copyright 2015-2018 IS2T. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break IS2T warranties on the whole library.
 */
package ej.service.loader;

import ej.annotation.Nullable;

/**
 * Service loader that retrieves services implementations using system properties.
 *
 * @see System#getProperty(String)
 */
public class SystemPropertiesServiceLoader extends DependencyInjectionServiceLoader {

	@Override
	@Nullable
	protected String getImplementationName(String serviceName) {
		return System.getProperty(serviceName);
	}

}
