/*
 * Copyright 2014-2019 IS2T. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break IS2T warranties on the whole library.
 */
package ej.service;

import ej.annotation.Nullable;

/**
 * A simple service loading facility.
 * <p>
 * A service is usually defined by an interface (but that may be a class). The service loader associates a service with
 * an instance of this service. This instance may be retrieved in different ways:
 * <ul>
 * <li>dependency injection: the implementation of the service is described in a configuration file (properties file for
 * example) and this implementation is instantiated on demand. Once the instance is created, it is kept for ever.</li>
 * <li>service registration: the instance is explicitly registered at runtime by a service provider.</li>
 * </ul>
 */
public interface ServiceLoader {

	/**
	 * Gets the instance of the given service.
	 * <p>
	 * If there is already an instance in cache, it is returned otherwise a new one is created.
	 * <p>
	 * May return <code>null</code> if the service is not defined.
	 *
	 * @param service
	 *            the service.
	 * @param <T>
	 *            the service type.
	 * @return the instance of the given service.
	 * @throws ServiceLoadingException
	 *             if an error occurs while instantiating the service instance.
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to retrieve the given service instance.
	 */
	@Nullable
	<T> T getService(Class<T> service);

}
