/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

/**
 * The <code>BluetoothDescriptor</code> class represents a remote or a local GATT descriptor.
 * <p>
 * Remote descriptors may be retrieved by {@link BluetoothCharacteristic#getDescriptor(int) getting the descriptors} of
 * a remote characteristic.
 * <p>
 * Local descriptors may be retrieved by {@link BluetoothAdapter#addService adding a local service} to the adapter.
 * <p>
 * This class provides a method to get the characteristic to which the descriptor belongs.
 */
public class BluetoothDescriptor extends BluetoothAttribute {

	/**
	 * Private constructor.
	 */
	private BluetoothDescriptor() {
		throw new RuntimeException();
	}

	/**
	 * Returns the characteristic to which this descriptor belongs.
	 *
	 * @return the descriptor to which this descriptor belongs.
	 */
	public BluetoothCharacteristic getCharacteristic() {
		throw new RuntimeException();
	}
}
