/*
 * Java
 *
 * Copyright 2010-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui.led;

/**
 * This class is used to manage all LEDs available on the platform. The available number of LEDs is known thanks to the
 * method {@link #getNumberOfLeds()}. A LED is identified by to its identifier. The range of the identifiers is from
 * <code>0</code> to <code>getNumberOfLeds()-1</code>.
 */
public class Leds {

	/**
	 * Constant for turning off a LED.
	 */
	public static final int MIN_INTENSITY = 0x00;

	/**
	 * Constant for turning on a LED.<br>
	 * <br>
	 * If a LED does not handle intensity, any valid intensity different from {@link #MIN_INTENSITY} turns the LED on.
	 */
	public static final int MAX_INTENSITY = 0xFF;

	/**
	 * Forbidden constructor: cannot instantiate a Leds object.
	 */
	private Leds() {
	}

	/**
	 * Returns the available number of LEDs. The range of valid led identifiers is [0..Leds.getNumberOfLeds()-1].
	 *
	 * @return the number of leds
	 */
	public static int getNumberOfLeds() {
		throw new RuntimeException();
	}

	/**
	 * Controls the intensity of the specified LED. If the identifier is invalid (out of range) the method has no
	 * effect.
	 *
	 * @param ledId
	 *            the led identifier
	 * @param intensity
	 *            the intensity to set on the led
	 */
	public static void setLedIntensity(int ledId, int intensity) {
		throw new RuntimeException();
	}

	/**
	 * Gets the intensity of the specified LED. If the identifier is invalid (out of range) the method returns 0.
	 *
	 * @param ledId
	 *            the led identifier
	 * @return the led intensity
	 */
	public static int getLedIntensity(int ledId) {
		throw new RuntimeException();
	}

	/**
	 * Turns on the given LED. The effect is identical to <code>Leds.setLedIntensity(ledId, MAX_INTENSITY)</code>.
	 *
	 * @param ledId
	 *            the led identifier
	 */
	public static void setLedOn(int ledId) {
		throw new RuntimeException();
	}

	/**
	 * Turns off the given LED. The effect is identical to <code>Leds.setLedIntensity(ledId, MIN_INTENSITY)</code>.
	 *
	 * @param ledId
	 *            the led identifier
	 */
	public static void setLedOff(int ledId) {
		throw new RuntimeException();
	}

}
