# Overview

JSON in Java [package org.json]

JSON is a light-weight, language independent, data interchange format.
See http://www.JSON.org/

The files in this package implement JSON encoders/decoders in Java.
It also includes the capability to convert between JSON and XML.

This is a reference implementation. There is a large number of JSON packages
in Java. Perhaps someday the Java community will standardize on one. Until
then, choose carefully.

The package compiles on Java 1.6-1.8.


JSONObject.java: The JSONObject can parse text from a String or a JSONTokener
to produce a map-like object. The object provides methods for manipulating its
contents, and for producing a JSON compliant object serialization.

JSONArray.java: The JSONObject can parse text from a String or a JSONTokener
to produce a vector-like object. The object provides methods for manipulating
its contents, and for producing a JSON compliant array serialization.

JSONTokener.java: The JSONTokener breaks a text into a sequence of individual
tokens. It can be constructed from a String, Reader, or InputStream.

JSONException.java: The JSONException is the standard exception type thrown
by this package.

JSONString.java: The JSONString interface requires a toJSONString method,
allowing an object to provide its own serialization.

JSONStringer.java: The JSONStringer provides a convenient facility for
building JSON strings.

JSONWriter.java: The JSONWriter provides a convenient facility for building
JSON text through a writer.

XML.java: XML provides support for converting between JSON and XML.

XMLTokener.java: XMLTokener extends JSONTokener for parsing XML text.

Unit tests are maintained in a separate project. Contributing developers can test 
JSON-java pull requests with the code in this project: 
https://github.com/stleary/JSON-Java-unit-test

Numeric types in this package comply with ECMA-404: The JSON Data Interchange Format 
(http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-404.pdf) and 
RFC 7159: The JavaScript Object Notation (JSON) Data Interchange Format 
(https://tools.ietf.org/html/rfc7159#section-6). 
This package fully supports Integer, Long, and Double Java types. Partial support 
for BigInteger and BigDecimal values in JSONObject and JSONArray objects is provided 
in the form of get(), opt(), and put() API methods.


# Usage

Add the following line to your `module.ivy`:
	
    <dependency org="org.json.me" name="json" rev="1.3.0"/>
	
# Requirements

This library requires the following Foundation Libraries:

    EDC-1.2

# Dependencies

_All dependencies are retrieved transitively by Ivy resolver_.

# Source

N/A

# Restrictions

None.

---  
_Copyright 2016-2019 MicroEJ Corp. This file has been modified by MicroEJ Corp._  