# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [5.0.0] - 2025-01-24

### Changed

- Implement LLAPI of UI Pack 14.3.0.
- Show the pointer coordinates in the Front Panel status bar (instead of a tooltip).

### Fixed

- Fix the implementation of the drawing methods in the image of the display (current back buffer).

### Removed

- Remove the flush visualizer (moved in the UI Pack's Front Panel engine).
- Remove the class `ej.fp.widget.display.Rectangle` (use UI Pack's class `ej.microui.display.Rectangle` instead).

## [4.0.2] - 2024-10-01

### Fixed

- Fix the disappearance of drawings when resizing the window using the TransmitSwapBufferPolicy.
- Fix FlushVisualizer which prevented an application from being run twice.  

## [4.0.1] - 2024-04-09

### Changed

- Homogenize the notions of back and front buffers.
- Homogenize the notion of "transmit & swap" (shared between the display connections serial and parallel).

### Fixed

- Allow BRS dirty color to be semi-transparent.
- Manage correctly 24-bit RGB colors for BRS drawn and restored colors.
- Fix the error message when the SingleRefreshStrategy is used with more than one buffer.

## [4.0.0] - 2024-02-14

### Added

- Manage several display buffer policies and refresh strategies.
- Print drawing color in flush visualizer.
- Add the possibility to show pointer coordinates on the display.

### Changed

- Compatible with UI Pack 14.0.0.
- Activate flush visualizer with a property instead of a new widget.

### Fixed

- Fix clip and drawn area computing in flush visualizer.

## [3.0.0] - 2023-07-10

- Adapt MicroUI Flush Visualizer Display to UI Pack 13.5.1.

## [2.2.0] - 2023-07-10

### Added

- Add MicroUI Flush Visualizer as a new Display.

## [2.1.1] - 2022-11-15

### Fixed

- Use opaque image for display buffer.
- Fix the translucent display (global opacity != 0xff).

## [2.1.0] - 2022-05-05

### Changed

- Compatible with UI Pack 13.1.0.
- Widget Display: simulate the embedded display flush time and refresh rate. 
- Change license terms to MicroEJ Corp. BSD-style license.
  
## [2.0.0] - 2020-07-30

### Changed

- Compatible with UI Pack 13.x (not backward compatible).

## [1.0.3] - 2020-07-08

### Fixed

- Dependencies: front panel framework 1.0.0 and widget-microui 1.0.0 are compatible.
  
## [1.0.2] - 2020-04-09

### Fixed

- Display: check on opacity level (alpha) was wrong.

## [1.0.1] - 2019-10-16

### Fixed

- Add a filtering delay to reduce the number of move events sent to the application.

## [1.0.0] - 2019-04-09

### Added

- Initial revision based on Front Panel _mockFPWidgets.jar_ of MicroEJ UI architecture extension 11.2.0.
- Compatible with Front Panel Framework 1.0.0 and higher (available MicroEJ architecture 7.11.0 and higher).
- Compatible with MicroUI Graphical Engine 11.0.0 and higher (available MicroEJ UI architecture extension 12.0.0 and higher).
- Compatible with MicroUI widgets for Front Panel 1.0.0 and higher.
- Holds implementation of basic UI widgets.

---  
_Copyright 2019-2025 MicroEJ Corp. All rights reserved._
_Use of this source code is governed by a BSD-style license that can be found with this software._  
