# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [5.2.0] - 2024-07-01

### Added

- Add methods to move a `SwipeEventHandler` to the beginning or the end.

### Fixed

- Allow to create a SwipeEventHandler with one item when not cyclic (previously throwing an IllegalArgumentException).
- Fix `SwipeEventHandler` to avoid ignoring drags in the right orientation after dragging in the wrong orientation.
- Fix `SwipeEventHandler` to avoid being stuck outside the limits.

## [5.1.0] - 2024-02-02

### Added

- Add Flex container.

### Fixed

- Fix wrapping strings starting with '\n'.
- Fix debug constants classnames.
- Fix `ArrayIndexOutOfBoundsException` in `GradientHelper.createGradient()` for 32-bit displays.

## [5.0.0] - 2023-09-15

### Added

- Add APIs to hierarchy inspector: generic visitor, widget type counter & style.
- Add monitor for widget rendering.
- Add monitor for animator debugging.
- Add base implementation for pointer-based event handlers.
- Add generic click event handler.

### Fixed

- Fix widget counter: containers are now included.
- Fix gradient helper: support trivial case with same color for gradient start and end.
- Fix `SwipeEventHandler`: `Swipeable.onSwipeStopped()` was not called in all swipe stop cases.
- Fix `SwipeEventHandler` dragging target position (was off by 1 when "dragging positively").

### Changed

- `SwipeEventHandler` constructors now require an additional argument for attached widget (API break).
- Rename all `util` packages (API break).
- Improve name of widgets from anonymous classes in debug utilities.
- Make `Button` and `ImageButton` use the new generic click event handler.
- Migrate to gradle.

## [4.2.0] - 2022-10-18

### Added

- Add FixedGrid container.

### Changed

- Update SwipeEventHandler to have a smoother animation when dragging pointer.

### Fixed

- Do nothing when swipe event handler is moved to the same position.
- Do not stop a MotionAnimation when it's restarted or not started.

## [4.1.0] - 2021-09-14

### Added

- Add helper methods to print the path of a widget.

### Changed

- Update MWT dependency to 3.3.0.
- Update enabled widgets to use new Widget constructor.

## [4.0.0] - 2021-05-10

### Added

- Add motion animation.
- Add API to get the current position of a swipe event handler.

### Changed

- Update motion dependency to 4.0.0.
- Add `Animator` parameter in every constructor of swipe event handler.
- Update MWT dependency to 3.2.1.
- Do not handle `PointerEventDispatcher.EXITED` event in the swipe event handler.

### Removed

- Remove `setAnimator()` API of swipe event handler.

### Fixed

- Fix swipe event handler snapping when calling `moveTo(int)` API.

## [3.1.1] - 2020-12-21

### Fixed

- Update dependencies to EDC, MicroUI, Drawing and MWT.
- Move call to setEnabled() in onAttached().

## [3.1.0] - 2020-09-21

### Added

- Allow the user to select the animator to use in a swipe event handler.

### Changed

- Update Basictool dependency to 1.5.0.
- Update MWT dependency to 3.1.0.

### Removed

- Remove dependency to service library.
- Remove `ej.bon.Timer` from required types.
- Remove `ej.bon.Timer` property.

## [3.0.0] - 2020-08-28

### Changed

- Depends on MicroUI 3 and MWT 3.
- Reorganize packages.

### Added

- Add Null annotations.
- Add an image widget that manage image lifecycle (open / close).

### Removed

- Remove animation framework (moved to MWT library).
- Remove style framework (moved to MWT library).
- Remove several widgets.
- Remove some containers.

### Fixed

- Fix SwipeEventHandler when:

    - pointer exits the widget,
    - included in another SwipeEventHandler with the other direction.

- Notify the swipe listener of a SwipeEventHandler only once.

## [2.4.2] - 2019-11-29

### Fixed

- Fix notifyStartAnimation() not called in moveTo(int stop, long duration).

## [2.4.1] - 2019-04-03

### Added

- Add getters for first and last widgets in split.
- Add getters for first, center and last widgets in simple dock.
- Implement equals() and hashCode() in style classes.

## [2.4.0] - 2019-03-08

### Changed

- Use MMM.

## [2.3.8] - 2019-01-23

### Fixed

- Remove useless call to validate in TransitionContainer.

## [2.3.7] - 2018-12-12

### Added

- Add null analysis annotations.

## [2.3.6] - 2018-12-05

### Fixed

- Fix TextHelper.splitStringInLines() if the string starts with a new line.

## [2.3.5] - 2018-02-01

### Fixed

- Clean Animator cache when no more animations.
- Fix Animator.setPeriod() when the animator is running.

## [2.3.4] - 2018-01-31

### Fixed

- IllegalAccessError E=F1 when using SlideTransitionContainer in multi-application context.

## [2.3.3] - 2017-12-19

### Fixed

- Fix SwipeEventHandler when:
- pointer exits the widget,
- included in another SwipeEventHandler with the other axis.
- Notify the animation listener of a SwipeEventHandler only once.
- Fix synchronization issue in SlideTransitionContainer.
- Optimize SimpleRoundedBorder rendering.

## [2.3.2] - 2017-11-03

### Fixed

- New widget not shown on TransitionContainer when the latter is invisible.
- Animator service should always be retrieved using the ServiceLoader.getService() method that
  takes a default implementation as parameter.

## [2.3.1] - 2017-10-16

### Fixed

- Fixed startAnimation called even if the widget is not visible in
  ScreenshotTransitionContainer and SlideTransitionContainer.
- Start and stop the underlying timer task when the first animation starts or the last animation stops.
- Use ej.bon.Util.platformTimeMillis() instead of System.currentTimeMillis as the former is monotonic.
- Depend on ej.library.ui#motion;3.1.1 for the same reason.

## [2.3.0] - 2017-09-01

### Changed

- Add a gradient helper.
- Add a swipe event handler that helps moving a content under the pointer.
- Add methods to update label text and image source without repainting the widget.
- Add an active state to the toggle wrapper when pressed (same as button).
- Avoid updating style when not necessary.
- A text widget can be activated manually (not using library focus).
- Simplify buttons: simple elements instead of composite ones.
- Add toggle box widget (a box linked to a toggle model).
- Manage focus state for all widgets (and composites).
- Create scrolling menu.
- Create transition container to switch between two widgets with an animation.

### Fixed

- Fix bounds of children of elements with a fixed dimension and an alignment.
- Fix button not being clicked when the pointer is dragged without exiting.
- Reduce clickable zone to inner widgets of button wrapper.
- Fix delay in transition managers when swiping.
- Fix and optimize the complex text manager.
- Fix flow layout.
- Fix horizontal screenshot transition with margin applied on navigator.
- Exclude margin from clickable area of the elements.
- Fix panel child bounds.
- DrawScreenHelper does not respect the panels' order.
- Fix cropped circle for circular progress bar.

## [2.2.1] - 2017-04-07

### Fixed

- Make library compliant with KF.

## [2.2.0] - 2017-02-13

### Changed

- Add elements icons.
- Add button image and animated image friendly names.
- The simple navigator can directly show a page.
- Provide an adapter for OnValueChangeListener.
- Add revalidate of a sub hierarchy.
- Panel adjusted to its child can be aligned using styles.
- Colorize alpha images in backgrounds.

### Fixed

- Add missing annotation for animated image attribute.
- Add missing disabled child annotation for toggle and button image.
- Reset graphics context between each element rendering.
- A button or toggle cannot get focus when it has no child.
- Fix ugly and not centered radio box with an even size.
- Fix descendant selector.
- Manage adjustedToChild property in Toggle and reduce clickable zone to inner widgets.

## [2.1.0] - 2016-12-15

### Changed

- Combinator now uses arrays instead of list for its children. /!\ This is an API break for combinator implementors.

### Fixed

- Fix remaining blink task if a Text has the focus when its panel is hidden.
- Fix wrapper validation when containing a composite.

## [2.0.0] - 2016-10-20

### Changed

- Specific style on a widget can be removed.
- A Wrapper can either adjust to its child or give it its preferred size.
- Review navigation framework.
- Specify default implementation programmatically (instead of using properties).

### Fixed

- Fix rounding problem on lists.
- Fix children style update when parent is updated.
- Fix descendant selector (last selector does not fit element).
- Fix canvas children size when specified.
- Fix scroll in a list.

## [2.0.0-alpha.10] - 2016-08-17

### Changed

- Several speed optimizations (mostly scroll & animations & split strings).
- Plain backgrounds define the graphics context background color.
- Review basic drawn widgets (draw only content & use style to customize).
- Use animation framework for all animations.
- Optimize widgets heap usage.
- Rework navigation framework organization (to integrate new features later).
- Add code snippets in widgets javadoc.
- Add type or subtype selector.
- Add a more complex dock layout.
- Automatically remove instance selectors from stylesheet.

### Fixed

- Fix _ArrayIndexOutOfBoundsException_ on _StyledPanel.getChild(0)_.
- Fix erroneous bounded range percentage compute.

## [2.0.0-alpha.9] - 2016-07-01

### Changed

- Animated image widget.
- A style can be set directly on a widget.
- Rename FitComposite (and children) to Wrapper.

## [2.0.0-alpha.8] - 2016-07-01

### Changed

- Update annotations dependency (new organization).

## [2.0.0-alpha.7] - 2016-06-28

### Changed

- An editable style can be reused for several rules.
- Style associated with a selector can be retrieved from a stylesheet.
- The border color is set directly in the style, it is not included in the border.
- Canvas defines its children size with their preferred size when not specified.
- Default font loader resolves fixed size font profiles.
- Empty text shows a place holder (and is in _Empty_ state).

### Fixed

- Fix rounded border and background.
- Fix scroll with a small content.
- Fix flow validation when the children fill all available size.
- Fix synchronization problems in stylesheet.

## [2.0.0-alpha.6] - 2016-06-07

### Changed

- Add an animation framework.
- Manage font style in font profile resolution.
- Accelerate style resolution (style merging, class selector, state selector, combinator with two children, simplify
  cascading).

### Fixed

- Fix stack state after a back until.
- Fix dock last child location.
- Fix list validation (fix one constraint depending on the orientation).

## [2.0.0-alpha.5] - 2016-05-20

### Changed

- Modify composites add / remove methods.
- Invalidate widgets when their content is modified.
- Provide a default stylized element implementation.
- Manage focus and _SELECT_ command on button and toggle.
- Associate a toggle to a group with a group name.
- Add central image loading (inspired by font loading).
- Add general sibling combinator.
- Add elements ID management and ID selector.

### Fixed

- Fix list validation (children are now given no constraint).
- Fix list getWidget(int) method.

## [2.0.0-alpha.4] - 2016-04-01

- Initial public revision.

### Added

- Styling.
- Common Widgets.
- Common containers.
- Navigation mechanism.
- Color utilities.

---  
_Copyright 2018-2024 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  
