# Overview

ej.rest is a tiny RESTful services client. 

## Features

- GET, POST, PUT, DELETE for text, JSON, binary
- Fluent-style API to follow hyperlinks easily
- Complex path queries for JSON (simple tests on fields with operators >,=,< and full boolean expressions (&&,||,!))
- Full support for multipart/form-data

# Usage

Add the following line to your `module.ivy`:
	
    <dependency org="ej.library.iot" name="restclient" rev="1.1.0"/>
	
# Requirements

This library requires the following Foundation Libraries:

    BON-1.3, EDC-1.2, NET-1.0-API-1.0

# Dependencies

_All dependencies are retrieved transitively by Ivy resolver_.

# Source

- Derived from http://beders.github.com/Resty

# Restrictions

None.

# Embedded constraints

Embedded execution environment has a limited amount of memory (RAM, Flash, etc.). Using Resty library in a such environment encourages the developer to precisely manage resources like sockets, files, etc.

Since HTTP 2.0, server defines keep-alive connections for every HTTP connection. When using Resty, developer has to take care of the number of opened sockets. In fact, many sockets can be opened at the same time and stay alive for a long time (keep-alive). To prevent having too much sockets opened, developers have to close the underlying HTTP connection of each REST call. The following code snippet shows how to correctly close such connection:

Resty allows to create access paths into a JSON object with a JSON query path. The parser of these expressions needs RAM buffers. Two different sizes can be configured:
	- The size of the buffers, through the property `ej.rest.jsonquerypath.buffersize`.
	- The expand size of the buffers, through the property `ej.rest.jsonquerypath.expandbuffersize`.

```java
Resty rest = new Resty();
try {
    // Do a REST call
    RawResource raw = this.rest.raw("http://my.url/data");
    // Close the underlying http connection
    raw.http().disconnect();
} catch (IOException e) {
    // something went horribly wrong
    e.printStackTrace();
}
```


---    
_Copyright 2016-2019 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  