# Overview

This library contains the Date and Time API for Java.

The library provides a default provider for timezone-rules. An application can set a custom default provider by setting 
the value of the constant `java.time.zone.DefaultZoneRulesProvider` to the full qualified name of the provider.

# Usage

Add the following line to your `module.ivy`:

    `<dependency org="ej.library.eclasspath" name="time" rev="1.0.0" />`

Add the following line to your `build.gradle.kts`:

    `implementation("ej.library.eclasspath:time:1.0.0")`
	
# Requirements

This library requires the following Foundation Libraries:

    EDC 1.3

# Dependencies

N/A

# Source

  - OpenJDK 8 u362-ga

# Restrictions

- Removed classes of non-ISO chronologies (`Hijrah*`, `Japanese*`, `Minguo*`, `ThaiBuddhist*`).
- Removed all classes of package `java.time.format` (all but `ResolverStyle`).
- Removed class `TzdbZoneRulesProvider`.
- Removed methods `parse`, `format`, `getDisplayName` and `ofLocale` for all types.
- Removed `@FunctionalInterface` keyword in interfaces.
- Removed `static` methods in all interfaces (see below).
- Removed `default` keyword in all interfaces (pulled down in concrete types).
- Removed static method `TemporalAdjusters.ofDateAdjuster(UnaryOperator<LocalDate> dateBasedAdjuster)`.
- Removed static method `WeekFields.of(Locale locale)`.
- Moved static interface method `timeLineOrder` from interfaces `ChronoLocalDate`, `ChronoLocalDateTime` and `ChronoZonedDateTime` to concrete types `LocalDate`, `LocalDateTime` and `ZonedDateTime` (resp.).
- Removed overflow checks on calculations and related `throws ArithmeticException`.
- Removed null checks on method arguments (rely on javadoc and annotations to enforce non-null behavior).
- Removed method `registerProvider(ZoneRulesProvider provider)` from class `ZoneRulesProvider`. Set
  the value of the constant `java.time.zone.DefaultZoneRulesProvider` to the Full Qualified name of the provider class.

## Interface static methods
- `java.time.chrono.ChronoLocalDate.from(TemporalAccessor)`: **removed**
- `java.time.chrono.ChronoLocalDate.timeLineOrder()`: **removed**, use `java.time.LocalDate.timeLineOrder()` instead
- `java.time.chrono.ChronoLocalDateTime.from(TemporalAccessor)`: **removed**
- `java.time.chrono.ChronoLocalDateTime.timeLineOrder()`: **removed**, use `java.time.LocalDateTime.timeLineOrder()` instead
- `java.time.chrono.ChronoZonedDateTime.from(TemporalAccessor)`: **removed**
- `java.time.chrono.ChronoZonedDateTime.timeLineOrder()`:: **removed**, use `java.time.ZonedDateTime.timeLineOrder()` instead
- `java.time.chrono.ChronoPeriod.between(ChronoLocalDate, ChronoLocalDate)`: **removed**
- `java.time.chrono.Chronology.from(TemporalAccessor)`: **removed**, use `java.time.chrono.AbstractChronology.from(TemporalAccessor)` instead
- `java.time.chrono.Chronology.getAvailableChronologies()`: **removed**, use `java.time.chrono.AbstractChronology.getAvailableChronologies()` instead
- `java.time.chrono.Chronology.of(String)`: **removed**, use `java.time.chrono.AbstractChronology.of(String)` instead
- `java.time.chrono.Chronology.ofLocale(Locale)`: **removed**



---    
_Markdown_  
_Copyright 2023 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp._
_DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER._
_ _
_This code is free software; you can redistribute it and/or modify it_
_under the terms of the GNU General Public License version 2 only, as_
_published by the Free Software Foundation.  Oracle designates this_
_particular file as subject to the "Classpath" exception as provided_
_by Oracle in the LICENSE file that accompanied this code._
_ _
_This code is distributed in the hope that it will be useful, but WITHOUT_
_ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or_
_FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License_
_version 2 for more details (a copy is included in the LICENSE file that_
_accompanied this code)._
_ _
_You should have received a copy of the GNU General Public License version_
_2 along with this work; if not, write to the Free Software Foundation,_
_Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA._
_ _
_Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA_
_or visit www.oracle.com if you need additional information or have any_
_questions. _