# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.6.0] - 2023-11-09

### Added
 - Support of X509 Certificate validity verification via the following APIs:    
    - `java.security.cert`: Class `java.security.cert.CertificateExpiredException` has been added.
    - `java.security.cert`: Class `java.security.cert.CertificateNotYetValidException` has been added.
    - `java.security.cert.X509Certificate`: method `checkValidity()` has been added.


## [1.5.0] - 2023-10-13

### Added
 - Support of Password Based Encryption (PBE) via the following APIs:    
    - `javax.crypto`: Class `javax.crypto.SecretKeyFactory` has been added.
    - `javax.crypto.spec`: Class `javax.crypto.spec.PBEKeySpec` has been added.

### Fixed

  - Fix broken Javadoc links 
  - Redirect mentions of the "Java Cryptography Architecture Standard Algorithm Name Documentation" to up-to-date links on Oracle website

## [1.4.2] - 2022-08-26

### Changed

  - Change MicroEJ copyrights.

## [1.4.1] - 2022-04-07

### Fixed

  - License and copyrights cleanup.

## [1.4.0] - 2021-10-07

### Added

  - Key pair generation for RSA and EC algorithms.
  - API changes:    
    - `java.security.InvalidParameterException`: Class `java.security.InvalidParameterException` added.
    - `java.security.KeyFactory`: Method 'public java.security.PublicKey generatePublic(java.security.spec.KeySpec)' has been added.
    - `java.security.KeyPair`: Class `java.security.KeyPair` added.
    - `java.security.KeyPairGenerator`: Class `java.security.KeyPairGenerator` added with following limitations:
        - The `SecureRandom` parameter is ignored in `java.security.KeyPairGenerator.initialize(int, SecureRandom)`.
        - The `SecureRandom` parameter is ignored in `java.security.KeyPairGenerator.initialize(AlgorithmParameterSpec, SecureRandom)`.
    - `java.security.KeyPairGeneratorSpi`: Class `java.security.KeyPairGeneratorSpi` added.
    - `java.security.SecurityPermission`: Class `java.security.SecurityPermission` added.
    - `java.security.spec.ECGenParameterSpec`: Class `java.security.spec.ECGenParameterSpec` added.
    - `java.security.spec.RSAKeyGenParameterSpec`: Class `java.security.spec.RSAKeyGenParameterSpec` added.
    - `java.security.spec.X509EncodedKeySpec`: Class `java.security.spec.X509EncodedKeySpec` added.
    - `javax.security.auth.x500.X500Principal`: Method 'public byte[] getEncoded()' has been added.
    - `sun.security.x509.AlgorithmId`: Class `sun.security.x509.AlgorithmId` added with following limitations:
        - The `oid` attribute is stored as a `String` in this class instead of the `ObjectIdentifier` class.
        - The method `AlgorithmId#getOID()` returns `String` instead of `ObjectIdentifier`.

## [1.3.2] - 2020-11-19

### Changed

  - Marked APIs with annotations for Null Analysis.

## [1.3.1] - 2019-02-19

### Fixed

  - Fix missing `KeyStoreSPI` API. 

## [1.3.0] - 2019-02-07

### Added

  - Add `Signature` sign.
  - Add `KeyFactory` API.

## [1.2.1] - 2019-01-23

### Fixed

  - Fix module `libname` to match the version number.

## [1.2.0] - 2018-12-20

### Added

  - Add `SecureRandom` API.

## [1.1.0] - 2018-08-31

### Added

  - Add verify method on Certificate.

## [1.0.0] - 2018-05-16

### Added

  - Initial revision.

---
_Copyright 2017-2023 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp._  
_DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER._  

_This code is free software; you can redistribute it and/or modify it_
_under the terms of the GNU General Public License version 2 only, as_
_published by the Free Software Foundation. The Copyright holder(s) designates_
_this particular file as subject to the "Classpath" exception as provided_
_by the Copyright holder(s) in the LICENSE file that accompanied this code._

_This code is distributed in the hope that it will be useful, but WITHOUT_
_ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or_
_FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License_
_version 2 for more details (a copy is included in the LICENSE file that_
_accompanied this code)._

_You should have received a copy of the GNU General Public License version_
_2 along with this work; if not, write to the Free Software Foundation,_
_Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA._

_Please contact the Copyright holder(s) if you need additional information_
_or have any questions._  
_(if Oracle: 500 Oracle Parkway, Redwood Shores, CA 94065 USA or visit www.oracle.com)_
