# Overview

MicroEJ Foundation Library implementation: `net-1_1-testsuite`.

# Usage

Add the following line to your `module.ivy`:

    <dependency org="com.microej.pack.net" name="net-1_1-testsuite" rev="4.2.0"/>

# Requirements

This library requires the following Foundation Libraries:

    BON-1.4, EDC-1.3, NET-1.1

# Dependencies

_All dependencies are retrieved transitively by MicroEJ Module Manager_.

# Source

N/A.

# Restrictions

None.

# Configuration

Several MicroEJ Java properties must be defined to configure this testsuite. Some are defined for the server application and some for the MicroEJ Standalone Application.

The properties are used in the `com.microej.tests.util.TestNetTools` class.

## Properties For MicroEJ Standalone Test Application

If you are defining the property within the easyant scripts (e.g. a property file in the testsuite project), then the property name be prefixed with `microej.java.property.`.

Common properties:

  - `testsuite.preferipv6` (optional, false by default): set to true if
    the tests must use IPv6 by default
  - `init.service` (optional, undefined by default): Name of a class
    that implements
    `com.microej.tests.util.INetInit`. If defined,
    during initialization, an instance of this class is created and the
    `initialize()` method is called.

Properties to defined if `testsuite.preferipv6` is **false**

  - `wrong.machine.ipv4`: An invalid IPv4 address on the local network
  - `remote.machine.ipv4`: IPv4 address of the testsuite server
  - `netif.ipv4.name`: network interface name with an IPv4

Properties to defined if `testsuite.preferipv6` is **true**

  - `wrong.machine.ipv6`: An invalid IPv6 address on the local network
  - `remote.machine.ipv6`: IPv6 address of the testsuite server
  - `netif.ipv6.name`: network interface name with an IPv6

When testing a device with a dual-stack IPv6+IPv4, the following
properties must be set:

  - `remote.machine.ipv4`: see above
  - `netif.ipv4.name`: see above
  - `remote.machine.ipv6`: see above
  - `netif.ipv6.name`: see above

## Test-specific properties

### TestSocketParallel

This test opens and connects up to `testsocketparallel.nbsockets` in parallel to a test server running on `remote.machine.ipv{4,6}`. Up to `testsocketparallel.nbthreads` can write predictable natural number sequences to an echo TCP server. The sequences are sent back to the client sockets, which verifies that the received sequence matches what was sent. The test must run without errors for `testsocketparallel.duration` seconds in order to succeed. Sockets have a `testsocketparallel.chanceclosesocketpercent` percent chance to close from the client side – new sockets will be opened and connected to replace them as long as the test hasn't run for the requested duration.

These properties come with default values, if undefined, compatible with a short running CI. They must be prefixed with `microej.java.property`:

| Key | Description | Default |
|:----|:------------|--------:|
| testsocketparallel.nbsockets | Number of sockets opened concurrently | 4 |
| testsocketparallel.nbthreads | Number of threads reading/writing from the socket pool | 3 |
| testsocketparallel.duration | Test duration, in seconds, required for success. Five minutes is a reasonable duration to run in a frequent CI to detect high-occurrence problems. If run as a stress test, it should run for several hours. | 300 |
| testsocketparallel.chanceclosesocketpercent | Percent chance a socket will be closed when picked from the pool | 5 |

## How To Debug Server Application

The server application (or remote application) is executed in a spawned JVM launched from an Ant script defined in `content/scripts/init-net-1_1-testsuite` directory.
The output of this spawned JVM cannot be accessed directly (this is a limitation in Ant).
To bypass this issue the output can be redirected to a socket.

To do that:

  - Specify the log server address with the property `remoteapp.logging.host` (by default `localhost`)
  - Specify the log server port with the property `remoteapp.logging.port` (set it to `0` to disable the remote log feature ; this is the default value)
  - Start a log server. You can use netcat: `nc -l <port>` (where `<port>` is the port specified in the previous property)

**WARNING:**: Only the output written to `com.microej.tests.remoteapp.util.RemoteAppTest.out` will be redirected.
Use this field instead of `System.out` in the remote applications.
Use also `exception.printStackTrace(out)` instead of `exception.printStackTrace()`.

---

_Copyright 2014-2025 MicroEJ Corp. All rights reserved._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  
