# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## 2.0.0 - 2020-05-04

### Added
  - Set name of pump thread for debug.
  - Add annotations for null analysis.
  - Add license file.

### Changed
  - Support Bluetooth API 2.0.
  - Rename `BluetoothSNI` to `BluetoothNatives`.
  - Move tools package.
  - Use non-immortal buffers to call native methods (requires SNI 1.3).
  - Rename `bluetooth.events.buffer.size` property to `bluetooth.pump.buffer.size`.
  - Change module organization.

### Removed
  - Remove `bluetooth.natives.buffer.size` property.
  - Remove LLAPI from the rip.

### Fixed
  - Fix exception when passing negative integer to `BluetoothUuid` constructor.
  - Catch all exceptions when calling user code.
  - Decrease heap usage.

## 1.0.3 - 2019-10-10

### Fixed
  - Fix UUIDs serialization and deserialization.

## 1.0.2 - 2019-07-15

### Fixed
  - Fix KF exception in switch statement on enum object.
  - Fix properties initialization in bluetooth-init script.

## 1.0.1 - 2019-07-03

### Changed
  - Use two distinct properties for natives buffer size and events buffer size.

## 1.0.0 - 2019-03-12

### Added
  - Scan nearby devices.
  - Advertise to nearby devices.
  - Connect to and disconnect from a device.
  - Pair with a device.
  - Reply to a pairing request from a device.
  - Provide GATT services.
  - Discover the GATT services provided by a device.
  - Read or write a characteristic or descriptor of a device.
  - Reply to a read or write request from a device.
  - Send characteristic notifications and indications to a device.

---
_Copyright 2018-2020 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  
