# Overview

MicroEJ Add-On Library: `string-regex`.

This is an extension module for the `java.lang.String` class, adding support for methods relying on regular expressions processing support.

# Usage

Add the following line to your `module.ivy`:

    <dependency org="com.microej.library.runtime" name="string-regex" rev="1.0.1"/>
    
The methods in this extension module are meant to be used as similarly as possible to the standard Java `java.lang.String` methods of the same name. The underlying regular expression engine behind these additional regex-based methods is Jakarta Regexp. It provides a fairly simple and lightweight regular expression processing API, but has some limitations and behavior differences when compared to the standard Java methods.

## Known Limitations

- Mode modifiers (`(?x)`, `(?s)`, `(?i)`...) are not supported.
- Nested characters sets (brackets) are not supported.
- Curly Brackets: Only digits are supported for quantifying, no other use like Unicode specifications are supported.
- Lookaheads and lookbehinds, positive or negative, are not supported.
- `?` modifier is not supported on curly brackets quantifiers.

## Known Behavior Differences

- In a character set, one `-` character is used to indicate a range. If left with a missing left or right operand it will not be counted as a `-` character but the character range minimum or maximum will be 0 or `Character.MAX_VALUE` respectively. E.G. the expression `[a-]` will indicate a character range between `a` and `Character.MAX_VALUE`.
- In a character set, one `^` character that is not at the start of the set expression (in this case used for negation) will not be counted as a `^` character itself.
- While the `?` modifier is supported on `+`, `*` and `?` quantifiers to make them reluctant/lazy, the `??` reluctant quantifier has proven to cause errors at times.

For more information on the supported regular expressions features and expressivity, please refer to the Jakarta Regexp Javadoc.

# Requirements

This library requires the following Foundation Libraries:

    BON-1.4, EDC-1.3

# Dependencies

_All dependencies are retrieved transitively by MicroEJ Module Manager_.

# Source

N/A.

# Restrictions

None.

---    
_Markdown_  
_Copyright (c) 2022 Oracle and/or its affiliates. All rights reserved_.  
_Copyright 2022 MicroEJ Corp. This file has been modified by MicroEJ Corp._  
_DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER._  
_ _  
_This code is free software; you can redistribute it and/or modify it_  
_under the terms of the GNU General Public License version 2 only, as_  
_published by the Free Software Foundation.  Oracle designates this_  
_particular file as subject to the "Classpath" exception as provided_  
_ _  
_This code is distributed in the hope that it will be useful, but WITHOUT_  
_ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or_  
_FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License_  
_version 2 for more details (a copy is included in the LICENSE file that_  
_accompanied this code)._  
_ _  
_You should have received a copy of the GNU General Public License version_  
_2 along with this work; if not, write to the Free Software Foundation,_  
_Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA._  