# Overview

The MicroEJ support engine provides the glue methods required to run a MicroEJ Application on an Android Platform.

The `MicroEJSupport` class provides 2 interfaces:
- the `ApplicationSupport` interface can be used by Android Applications in order to setup the MicroEJ support engine and to handle display events.
- the `InternalSupport` interface can be used by Android Implementations of Foundation Libraries in order to get the current state of the MicroEJ support engine and to flush the display.

Unlike on MicroEJ VEE, this implementation does not load every `.properties.list` resource of the classpath, it only loads the `/properties/merged.properties.list` resource.

# Usage

Add the following line to your `module.ivy`:

    <dependency org="com.microej.android.support" name="microej-android" rev="1.1.3"/>

# Requirements

- Android SDK Platform 21

# Dependencies

_All dependencies are retrieved transitively by MicroEJ Module Manager_.

# Source

N/A.

# Restrictions

None.

---
_Copyright 2021-2023 MicroEJ Corp. All rights reserved._  
_MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms._
