/*
 * Java
 *
 * Copyright 2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.hoka.http.requesthandler;

import java.io.InputStream;
import java.util.Map;

import ej.annotation.Nullable;

/**
 * Request handler to serve static files.
 */
public interface StaticFilesHandler {

	/**
	 * Serve the request file if found, return code {@code null} is file not found.
	 *
	 * @param path
	 *            path of the reuqested file.
	 * @param headers
	 *            list of headers to append to the Http response.
	 * @return the file input stream or code {@code null} if the file is not found.
	 */
	@Nullable
	InputStream serve(String path, Map<String, String> headers);

}
