/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.bluetooth.BluetoothConnection;
import ej.library.iot.rcommand.bluetooth.BluetoothController;
import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;

public class SendPasskeyResponseEndpoint implements Endpoint {

	private final BluetoothController controller;

	private short connHandle;
	private boolean accept;
	private int passkey;

	public SendPasskeyResponseEndpoint(BluetoothController controller) {
		this.controller = controller;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_PASSKEY_REPLY;
	}

	@Override
	public void readRequestBody(CommandReader reader) throws IOException {
		this.connHandle = (short) reader.readInt();
		this.accept = reader.readBoolean();
		this.passkey = reader.readInt();
	}

	@Override
	public void writeResponseBody(CommandSender sender) throws IOException {
		BluetoothConnection connection = this.controller.getConnection(this.connHandle);
		if (connection != null && connection.sendPasskeyResponse(this.accept, this.passkey)) {
			sender.sendInt(Commands.OK);
		} else {
			sender.sendInt(Commands.ERROR);
		}
	}
}
