/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.annotation.Nullable;
import ej.bluetooth.BluetoothAdapter;
import ej.bluetooth.BluetoothAddress;
import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;

public class ConnectEndpoint implements Endpoint {

	private static final byte ADDRESS_TYPE_PUBLIC = 0x00;

	private @Nullable byte[] deviceAddress;

	@Override
	public String getName() {
		return Commands.BLUETOOTH_CONNECT;
	}

	@Override
	public void readRequestBody(CommandReader reader) throws IOException {
		this.deviceAddress = reader.readByteArray();
	}

	@Override
	public void writeResponseBody(CommandSender sender) throws IOException {
		byte[] deviceAddress = this.deviceAddress;
		assert (deviceAddress != null);
		boolean isPublic = (deviceAddress[0] == ADDRESS_TYPE_PUBLIC);
		BluetoothAddress address = new BluetoothAddress(deviceAddress, 1, isPublic);
		if (BluetoothAdapter.getAdapter().connect(address)) {
			sender.sendInt(Commands.OK);
		} else {
			sender.sendInt(Commands.ERROR);
		}
	}
}
