/*
 * Java
 *
 * Copyright 2018-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth;

public class HexTools {

	private static final char[] HEX_TABLE = new char[] { '0', '1', '2', '3', '4', '5', '6', '7', //
			'8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

	private HexTools() {
		// private constructor
	}

	public static void byteToString(byte b, char[] string, int stringIndex) {
		int value = (b & 0xFF);
		string[stringIndex + 0] = HEX_TABLE[value >> 4];
		string[stringIndex + 1] = HEX_TABLE[value & 0xF];
	}

	public static byte stringToByte(String string, int stringIndex) {
		char c0 = string.charAt(stringIndex);
		char c1 = string.charAt(stringIndex + 1);
		return (byte) (getHexValue(c0) << 4 | getHexValue(c1));
	}

	private static int getHexValue(char c) {
		if (c >= '0' && c <= '9') {
			return (c - '0');
		} else if (c >= 'a' && c <= 'f') {
			return (c - 'a') + 0xA;
		} else if (c >= 'A' && c <= 'F') {
			return (c - 'A') + 0xA;
		} else {
			throw new IllegalArgumentException();
		}
	}
}
