/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.kf.util;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link Byte}. This converter creates a clone of the original {@link Byte}.
 */
public class ByteConverter implements Converter<Byte> {

	@Override
	public Byte convert(Byte arg0, Feature targetOwner) throws IllegalAccessError {
		final byte value = arg0.byteValue();
		RunnableWithResult<Byte> runnable = new RunnableWithResult<Byte>() {
			@Override
			public Byte runWithResult() {
				return new Byte(value);
			}
		};
		Kernel.runUnderContext(targetOwner, runnable);
		return runnable.getResult();
	}

	@Override
	public Class<Byte> getType() {
		return Byte.class;
	}

}