/*
 * Java
 *
 * 2015-2021 ESR - Not subject to Copyright.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui;

import ej.microui.display.Display;
import ej.microui.display.Font;
import ej.microui.event.EventGenerator;

/**
 * Thrown to indicate that a method has caused an internal MicroUI error. This error is specified by an identifier and
 * this identifier can be retrieved calling {@link #getErrorCode()}.
 */
public class MicroUIException extends RuntimeException {

	/**
	 * Exception thrown when trying to use MicroUI APIs without starting it before.
	 * <p>
	 * Value <code>-1</code> is assigned to <code>MICROUI_NOT_STARTED</code>.
	 *
	 * @see MicroUI#start()
	 * @see MicroUI#stop()
	 * @see MicroUI#isStarted()
	 */
	public static final int MICROUI_NOT_STARTED = -1;

	/**
	 * Exception thrown when generic event generator classname is unknown. Please check your classpath to add the
	 * expected class.
	 * <p>
	 * Value <code>-2</code> is assigned to <code>GENERIC_EVENT_GENERATOR_INVALID_CLASSNAME</code>.
	 */
	public static final int GENERIC_EVENT_GENERATOR_INVALID_CLASSNAME = -2;

	/**
	 * Exception thrown when trying to wait for an event in the same thread that treats events (Deadlock).
	 * <p>
	 * Value <code>-3</code> is assigned to <code>DISPLAY_DEADLOCK</code>.
	 *
	 * @see MicroUI#isUIThread()
	 * @see MicroUI#isUIThread(Thread)
	 */
	public static final int DISPLAY_DEADLOCK = -3;

	/**
	 * Exception thrown when a resource cannot be retrieved. Path must be relative to the application classpath and
	 * starts with '/'.
	 * <p>
	 * Value <code>-4</code> is assigned to <code>RESOURCE_INVALID_PATH</code>.
	 */
	public static final int RESOURCE_INVALID_PATH = -4;

	/**
	 * Exception thrown when the resource content cannot be read for any reason.
	 * <p>
	 * Value <code>-5</code> is assigned to <code>RESOURCE_INVALID_FILE</code>.
	 */
	public static final int RESOURCE_INVALID_FILE = -5;

	/**
	 * Exception thrown when the application is trying to use a resource which has been closed.
	 * <p>
	 * Value <code>-6</code> is assigned to <code>RESOURCE_CLOSED</code>.
	 */
	public static final int RESOURCE_CLOSED = -6;

	/**
	 * Exception thrown when there is not enough space in images heap when creating a new image.
	 * <p>
	 * Value <code>-7</code> is assigned to <code>IMAGE_OUT_OF_MEMORY</code>.
	 */
	public static final int IMAGE_OUT_OF_MEMORY = -7;

	/**
	 * Exception thrown when the image cannot be decoded because there is no runtime decoder able to decode this kind of
	 * image.
	 * <p>
	 * Value <code>-8</code> is assigned to <code>IMAGE_UNKNOWN_FORMAT</code>.
	 */
	public static final int IMAGE_UNKNOWN_FORMAT = -8;

	/**
	 * Exception thrown when {@link Display}'s event serializer queue is full. The new event cannot be added to this
	 * queue. Review the queue size or decrease the number of events added to this queue.
	 * <p>
	 * Value <code>-9</code> is assigned to <code>OUT_OF_EVENTS</code>.
	 */
	public static final int OUT_OF_EVENTS = -9;

	/**
	 * Exception thrown when the application tries to get a {@link Display} whereas there is no {@link Display} on the
	 * platform.
	 * <p>
	 * Value <code>-10</code> is assigned to <code>NO_DISPLAY</code>.
	 */
	public static final int NO_DISPLAY = -10;

	/**
	 * Exception thrown when the application tries to get a {@link Font} whereas there is no {@link Font} on the
	 * platform.
	 * <p>
	 * Value <code>-11</code> is assigned to <code>NO_FONT</code>.
	 */
	public static final int NO_FONT = -11;

	/**
	 * Exception thrown when the pool of {@link EventGenerator} is full.
	 * <p>
	 * Value <code>-12</code> is assigned to <code>EVENTGENERATOR_POOL_FULL</code>.
	 *
	 * @see EventGenerator#addToSystemPool()
	 */
	public static final int EVENTGENERATOR_POOL_FULL = -12;

	private static final long serialVersionUID = -6786967399358365561L;

	/**
	 * Constructs an exception with the specified error code.
	 *
	 * @param errorCode
	 *            the exception error code
	 */
	public MicroUIException(int errorCode) {
		throw new RuntimeException();
	}

	/**
	 * Gets the reason why the exception has been thrown.
	 *
	 * @return the exception error code
	 */
	public int getErrorCode() {
		throw new RuntimeException();
	}
}
