/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg.image;

import ej.microvg.image.pathdata.PathData;

/**
 * A VG path.
 * <p>
 * The implementations and instances of this interface are provided by the image generator engine.
 */
public interface Path {

	/**
	 * Gets the left x coordinate of the path's bounding box.
	 *
	 * @return the bounding box's left x.
	 */
	double getMinX();

	/**
	 * Gets the right x coordinate of the path's bounding box.
	 *
	 * @return the bounding box's right x.
	 */
	double getMaxX();

	/**
	 * Gets the top y coordinate of the path's bounding box.
	 *
	 * @return the bounding box's top y.
	 */
	double getMinY();

	/**
	 * Gets the bottom y coordinate of the path's bounding box.
	 *
	 * @return the bounding box's bottom y.
	 */
	double getMaxY();

	/**
	 * Parses this path and encodes it in the given path data in a format dedicated to the GPU.
	 * <p>
	 * This method should be called in the implementations of {@link ImageGenerator#encodePath(Path)}.
	 *
	 * @param pathData
	 *            the path data to encode in
	 */
	void encode(PathData pathData);

}
