/*
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.components;

/**
 * Navigates across the UI.
 */
public interface Navigator {

	/**
	 * Handles a gesture.
	 * <p>
	 * The navigator may consume the gesture and show an other page.
	 *
	 * @param gesture
	 *            the gesture to handle.
	 * @return whether the gesture has been consumed.
	 */
	boolean handleGesture(Gesture gesture);

	/**
	 * Enumerates gestures.
	 */
	enum Gesture {

		/** Swipe left gesture. */
		SWIPE_LEFT,

		/** Swipe right gesture. */
		SWIPE_RIGHT,

		/** Swipe up gesture. */
		SWIPE_UP,

		/** Swipe down gesture. */
		SWIPE_DOWN,

		/** Top button press gesture. */
		TOP_BUTTON_PRESS,

		/** Top button long press gesture. */
		TOP_BUTTON_LONG_PRESS,

		/** Middle button press gesture. */
		MIDDLE_BUTTON_PRESS,

		/** Middle button long press gesture. */
		MIDDLE_BUTTON_LONG_PRESS,

		/** Bottom button press gesture. */
		BOTTOM_BUTTON_PRESS,

		/** Bottom button long press gesture. */
		BOTTOM_BUTTON_LONG_PRESS,

		/** Pointer long press gesture. */
		POINTER_LONG_PRESS
	}
}
