/*
 * Copyright (c) 1999, 2013, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2019 IS2T - EDC compliance and optimizations.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package javax.security.auth;

/**
 * Objects such as credentials may optionally implement this interface to provide the capability to destroy its
 * contents.
 */
public interface Destroyable {

	/**
	 * Destroy this {@code Object}.
	 *
	 * <p>
	 * Sensitive information associated with this {@code Object} is destroyed or cleared. Subsequent calls to certain
	 * methods on this {@code Object} will result in an {@code IllegalStateException} being thrown.
	 *
	 * <p>
	 * The default implementation throws {@code DestroyFailedException}.
	 *
	 * @exception DestroyFailedException
	 *                if the destroy operation fails.
	 *                <p>
	 *
	 * @exception SecurityException
	 *                if the caller does not have permission to destroy this {@code Object}.
	 */
	public void destroy() throws DestroyFailedException;

	/**
	 * Determine if this {@code Object} has been destroyed.
	 *
	 * <p>
	 * The default implementation returns false.
	 *
	 * @return true if this {@code Object} has been destroyed, false otherwise.
	 */
	public boolean isDestroyed();
}