/*
 * Java
 *
 * Copyright 2010-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.microui.event.generator;

import ej.microui.event.EventGenerator;

/**
 * Command is an event generator that generates application-level events. Unlike io generators that are related to some
 * hardware input format, the command generator defines its own input format. Basically input and output event are the
 * same. This allows the generation of commands from within MicroUI without relying on an underlying input event format.
 * <p>
 * This class defines constants for a set of basic commands. The commands defined in this class are typical
 * application-level effects of input events. The advantage of using commands rather than specific input events in an
 * application is that the application can be more portable: it is not tied to specific input devices.
 */

public class Command extends EventGenerator {

	/**
	 * The COMMAND event type returned by {@link #getEventType()}.
	 */
	public static final int EVENT_TYPE = 0x00;

	/**
	 * Constant for "escape" command.
	 */
	public static final int ESC = 0x0000;
	/**
	 * Constant for "back" command.
	 */
	public static final int BACK = 0x0001;
	/**
	 * Constant for "up" command.
	 */
	public static final int UP = 0x0002;
	/**
	 * Constant for "down" command.
	 */
	public static final int DOWN = 0x0003;
	/**
	 * Constant for "left" command.
	 */
	public static final int LEFT = 0x0004;
	/**
	 * Constant for "right" command.
	 */
	public static final int RIGHT = 0x0005;
	/**
	 * Constant for "select" command.
	 */
	public static final int SELECT = 0x0006;
	/**
	 * Constant for "cancel" command.
	 */
	public static final int CANCEL = 0x0007;
	/**
	 * Constant for "help" command.
	 */
	public static final int HELP = 0x0008;
	/**
	 * Constant for "menu" command.
	 */
	public static final int MENU = 0x0009;
	/**
	 * Constant for "exit" command.
	 */
	public static final int EXIT = 0x000A;
	/**
	 * Constant for "start" command.
	 */
	public static final int START = 0x000B;
	/**
	 * Constant for "stop" command.
	 */
	public static final int STOP = 0x000C;
	/**
	 * Constant for "pause" command.
	 */
	public static final int PAUSE = 0x000D;
	/**
	 * Constant for "resume" command.
	 */
	public static final int RESUME = 0x000E;
	/**
	 * Constant for "copy" command.
	 */
	public static final int COPY = 0x000F;
	/**
	 * Constant for "cut" command.
	 */
	public static final int CUT = 0x0010;
	/**
	 * Constant for "paste" command.
	 */
	public static final int PASTE = 0x0011;
	/**
	 * Constant for "clockwise" command.
	 */
	public static final int CLOCKWISE = 0x0012;
	/**
	 * Constant for "anti-clockwise" command.
	 */
	public static final int ANTICLOCKWISE = 0x0013;
	/**
	 * Constant for "previous" command.
	 */
	public static final int PREVIOUS = 0x0014;
	/**
	 * Constant for "next" command.
	 */
	public static final int NEXT = 0x0015;
	/**
	 * Constant for "display" command.
	 */
	public static final int DISPLAY = 0x0016;

	/**
	 * Creates a new command event generator.
	 */
	public Command() {
	}

	/**
	 * Gets the event generator's type. Default value is {@link #EVENT_TYPE}.
	 *
	 * @return the command generator's type
	 */

	@Override
	public int getEventType() {
		throw new RuntimeException();
	}

	/**
	 * Builds a MicroUI event for the given command.
	 *
	 * @param command
	 *            the command to be sent
	 * @return the MicroUI event
	 */
	public int buildEvent(int command) {
		throw new RuntimeException();
	}

	/**
	 * Sends the given command to the event generator's listener
	 *
	 * @param command
	 *            the command to be sent
	 */
	public void send(int command) {
		throw new RuntimeException();
	}

}
