/*
 * Copyright 2015-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.stylesheet.selector.combinator;

import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.stylesheet.selector.Selector;

/**
 * A descendant combinator selects by checking the widget hierarchy.
 * <p>
 * Equivalent to <code>widget widget</code> selector in CSS.
 *
 * @see Widget#getParent()
 */
public class DescendantCombinator extends Combinator {

	/**
	 * Creates a descendant combinator.
	 *
	 * @param selector1
	 *            the first selector.
	 * @param selector2
	 *            the second selector.
	 */
	public DescendantCombinator(Selector selector1, Selector selector2) {
		super(selector1, selector2);
	}

	@Override
	public boolean appliesToWidget(Widget widget) {
		// check that second selector applies to widget
		if (!getSecondSelector().appliesToWidget(widget)) {
			return false;
		}

		while (true) {
			// get parent
			Container parent = widget.getParent();
			if (parent == null) {
				return false;
			}

			// check that first selector applies to parent
			if (getFirstSelector().appliesToWidget(parent)) {
				return true;
			}

			// try next parent
			widget = parent;
		}
	}
}
