/*
 * Java
 *
 * Copyright 2021-2022 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.hoka.log;

import ej.hoka.http.Config;

/**
 * Factory class for the logger.
 */
public class LoggerFactory {

	/**
	 * You can set a logger implementation using the system property {@code hoka.logger.class}
	 *
	 * If the system property if not set or the class from {@code hoka.logger.class} is not found or can't be accessed
	 * or instantiated. an instance of {@link SimpleLogger} is returned with log to the standard output.
	 *
	 * @return logger instance of configured logger.
	 */
	public static Logger getLogger() {
		String className = Config.getInstance().getLoggerClassName();
		if (className == null || className.isEmpty() || className.trim().isEmpty()) {
			return new SimpleLogger();
		}
		try {
			Class<?> clazz = Class.forName(className.trim());
			return (Logger) clazz.newInstance();
		} catch (ClassNotFoundException | InstantiationException | IllegalAccessException e) {
			Logger logger = new SimpleLogger();
			logger.error("'" + className + "' logger not found", e); //$NON-NLS-1$ //$NON-NLS-2$
			return logger;
		}

	}

}
