/*
 * Java
 *
 * Copyright 2021-2022 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.hoka.http;

import java.util.ArrayList;
import java.util.List;

/**
 *
 */
class MethodNotAllowedException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	private final List<Route> allowedRoutes;

	/**
	 * @param possibleRoutes
	 *            route that match the request
	 */
	MethodNotAllowedException(List<Route> possibleRoutes) {
		super();
		this.allowedRoutes = new ArrayList<>(possibleRoutes);
	}

	protected String getAllowHeader() {
		StringBuilder allow = new StringBuilder();
		boolean addComa = false;
		for (Route r : this.allowedRoutes) {
			if (addComa) {
				allow.append(", "); //$NON-NLS-1$
			}
			allow.append(r.getHttpMethodAsString());
			addComa = true;
		}

		return allow.toString();
	}

}
