package java.lang;

/**
 * A <code>CharSequence</code> is a readable sequence of <code>char</code> values. This interface
 * provides uniform, read-only access to many different kinds of <code>char</code> sequences. A
 * <code>char</code> value represents a character in the <i>Basic Multilingual Plane (BMP)</i>.
 *
 * <p>
 * This interface does not refine the general contracts of the
 * {@link java.lang.Object#equals(java.lang.Object) equals} and {@link java.lang.Object#hashCode()
 * hashCode} methods. The result of comparing two objects that implement <code>CharSequence</code> is
 * therefore, in general, undefined. Each object may be implemented by a different class, and there
 * is no guarantee that each class will be capable of testing its instances for equality with those
 * of the other. It is therefore inappropriate to use arbitrary <code>CharSequence</code> instances as
 * elements in a set or as keys in a map.
 * </p>
 */

public interface CharSequence {

	/**
	 * Returns the <code>char</code> value at the specified index. An index ranges from zero to
	 * <code>length() - 1</code>. The first <code>char</code> value of the sequence is at index zero, the
	 * next at index one, and so on, as for array indexing.
	 *
	 * @param index
	 *        the index of the <code>char</code> value to be returned
	 *
	 * @return the specified <code>char</code> value
	 *
	 * @throws IndexOutOfBoundsException
	 *         if the <code>index</code> argument is negative or not less than <code>length()</code>
	 */
	char charAt(int index);

	/**
	 * Returns the length of this character sequence. The length is the number of 16-bit
	 * <code>char</code>s in the sequence.
	 *
	 * @return the number of <code>char</code>s in this sequence
	 */
	int length();

	/**
	 * Returns a new <code>CharSequence</code> that is a subsequence of this sequence. The subsequence
	 * starts with the <code>char</code> value at the specified index and ends with the
	 * <code>char</code> value at index <code>end - 1</code>. The length (in <code>char</code>s) of the
	 * returned sequence is <code>end - start</code>, so if <code>start == end</code> then an empty sequence is
	 * returned.
	 *
	 * @param start
	 *        the start index, inclusive
	 * @param end
	 *        the end index, exclusive
	 *
	 * @return the specified subsequence
	 *
	 * @throws IndexOutOfBoundsException
	 *         if <code>start</code> or <code>end</code> are negative, if <code>end</code> is greater than
	 *         <code>length()</code>, or if <code>start</code> is greater than <code>end</code>
	 */
	CharSequence subSequence(int start, int end);

	/**
	 * Returns a string containing the characters in this sequence in the same order as this sequence.
	 * The length of the string will be the length of this sequence.
	 *
	 * @return a string consisting of exactly this sequence of characters
	 */
	@Override
	String toString();

}
