package java.io;

import ej.annotation.Nullable;

/**
 * An OutputStreamWriter is a bridge from character streams to byte streams: Characters written to
 * it are encoded into bytes using a specified <code>charset</code>. The charset that it uses may be
 * specified by name or may be given explicitly, or the platform's default charset may be accepted.
 *
 * <p>
 * Each invocation of a write() method causes the encoding converter to be invoked on the given
 * character(s). The resulting bytes are accumulated in a buffer before being written to the
 * underlying output stream. The size of this buffer may be specified, but by default it is large
 * enough for most purposes. Note that the characters passed to the write() methods are not
 * buffered.
 *
 * @see OutputStream
 *
 */
public class OutputStreamWriter extends Writer {

	/**
	 * Creates an OutputStreamWriter that uses the default character encoding.
	 *
	 * @param out
	 *        An OutputStream
	 */
	public OutputStreamWriter(OutputStream out) {
		throw new RuntimeException();
	}

	/**
	 * Creates an OutputStreamWriter that uses the named charset.
	 *
	 * @param out
	 *        An OutputStream
	 *
	 * @param charsetName
	 *        The name of a supported <code>charset</code>
	 *
	 * @exception UnsupportedEncodingException
	 *            If the named encoding is not supported
	 */
	public OutputStreamWriter(OutputStream out, String charsetName) throws UnsupportedEncodingException {
		throw new RuntimeException();
	}

	/**
	 * Close the stream.
	 *
	 * @exception IOException
	 *            If an I/O error occurs
	 */
	@Override
	public void close() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Flushes the stream.
	 *
	 * @exception IOException
	 *            If an I/O error occurs
	 */
	@Override
	public void flush() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Returns the name of the character encoding being used by this stream.
	 *
	 * <p>
	 * If the encoding has an historical name then that name is returned; otherwise the encoding's
	 * canonical name is returned.
	 *
	 * <p>
	 * If this instance was created with the {@link #OutputStreamWriter(OutputStream, String)}
	 * constructor then the returned name, being unique for the encoding, may differ from the name
	 * passed to the constructor. This method may return <code>null</code> if the stream has been closed.
	 * </p>
	 *
	 * @return The historical name of this encoding, or possibly <code>null</code> if the stream has
	 *         been closed
	 */
	@Nullable
	public String getEncoding() {
		throw new RuntimeException();
	}

	/**
	 * Writes a portion of an array of characters.
	 *
	 * @param cbuf
	 *        Buffer of characters
	 * @param off
	 *        Offset from which to start writing characters
	 * @param len
	 *        Number of characters to write
	 *
	 * @exception IOException
	 *            If an I/O error occurs
	 */
	@Override
	public void write(char[] cbuf, int off, int len) throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Writes a single character.
	 *
	 * @exception IOException
	 *            If an I/O error occurs
	 */
	@Override
	public void write(int c) throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Writes a portion of a string.
	 *
	 * @param str
	 *        A String
	 * @param off
	 *        Offset from which to start writing characters
	 * @param len
	 *        Number of characters to write
	 *
	 * @exception IOException
	 *            If an I/O error occurs
	 */
	@Override
	public void write(String str, int off, int len) throws IOException {
		throw new RuntimeException();
	}
}